/* spo_log_idmef.h */

/*
** Copyright (C) 2000 Joe McAlerney, Silicon Defense, Inc. 
**                    <joey@silicondefense.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*  I N C L U D E S
**********************************************************/
#include "snort.h"
#include "idmefxml.h"
#include <errno.h>

/*  D E F I N E S
************************************************************/
#ifndef __LOG_IDMEF_H__
#define __LOG_IDMEF_H__

#define PLUGIN_IDMEF              18  /* The position in the otn's ds_list */
#define MAX_PLUGIN_ARGUMENT_COUNT 20  /* 20 key/value pairs should be enough */

/* rule types */
#define IDMEF_DEFAULT    0x01
#define IDMEF_WEB        0x02
#define IDMEF_OVERFLOW   0x04

/* IDMEF message information */
#define IDMEF_VERSION           "1"
#define XML_VERSION             "1.0"
#define IDMEF_MESSAGE_VERSION   "0.1"
#define DEFAULT_ALERTID_FN      "/var/log/alert_id_number"
#define MAX_PORT_DIGITS         5
#define HEX_ONLY_FRAME_SIZE     32
#define NO_URL                  "No URL available"

#define PAYLOAD_NONE            0
#define PAYLOAD_HEX             1
#define PAYLOAD_BASE64          2
#define PAYLOAD_ASCII           3

#define IDMEF_DEBUG 1

/*  D A T A  S T R U C T U R E S
*********************************************/

typedef struct _IDMEFRuleData
{
  int idmef_msg_type;
} IDMEFRuleData;

typedef struct _IDMEFMsgOptions
{
  int active;     /* indicates whether or not this msg type will be reported */
  int payload;    /* 0 for none, 1 for hex, 2 for base64, and 3 for ascii */
} IDMEFMsgOptions;

typedef struct _IDMEFPluginSettings
{
  char *logto;    /* The file name and path to log IDMEF alerts to (required)*/
  char *dtd;      /* The location of the dtd file (required) */

  /* IDS specific stuff */
  char *analyzer_id;  /* A unique identifier of this IDS (required) */
  char *category;     /* The domain type that this IDS is in */
  char *name;         /* The fully qualified domain naim of this IDS */
  char *location;     /* The physical location of this IDS */
  char *address;      /* The network address of this IDS */
  char *netmask;      /* The netmask of the address, if appropriate */
  char *address_cat;  /* The type (category) of address provided */

  /* Homenet specific stuff */
  IpAddrSet homenet;
  char *homenet_cat;  /* The domain type of the home network */
  char *homenet_loc;  /* The physical location of the home network */
  
  /* Alert specific stuff */

  char *alert_id_fn;
  int indent;          /* true or false, indent output? */
  
  IDMEFMsgOptions def; /* because "default" is a struct name somewhere */
  IDMEFMsgOptions web;
  IDMEFMsgOptions overflow;
} IDMEFPluginSettings;


/* G L O B A L  V A R I A B L E S
*********************************************/

ulong idmef_alertid;
char *idmef_alertid_str;
char *ntp_timestamp;
char *date_str;
char *time_str;
char *sport;
char *dport;
char *data_dump_buffer;
FILE *idmef_log_file;
FILE *alertid_file;

extern OptTreeNode *otn_tmp; /* global ptr to current rule data */
xmlNodePtr idmef_msg;

/* Preprocessor argument options */
IDMEFPluginSettings ips;

/*  P R O T O T Y P E S
******************************************************/
#ifdef ENABLE_IDMEF
void SetupIDMEFRule();
void IDMEFRuleInit(char *, OptTreeNode *, int);
void ParseIDMEFRule(char *, OptTreeNode *);
void SetupLogIDMEF();
void LogIDMEFInit(u_char *);
void ParseIDMEFArgs(char *);
void ParseIndividualArgs(char *);
void SanityCheckIDMEFArgs();
void LogIDMEF(Packet *, char *, void *);
void LogIDMEFCleanExit(int, void *);

xmlNodePtr BuildMessage(IDMEFMsgOptions *, Packet *, char *);
xmlNodePtr BuildAnalyzer(Packet *);
xmlNodePtr BuildSource(Packet *);
xmlNodePtr BuildTarget(Packet *);
void FreeMessage(IDMEFMsgOptions *, Packet *, char *);
void incAndFlush();

#endif

#endif /* __LOG_IDMEF_H__ */
