/* DO NOT EDIT THIS FILE. EDIT THE ORIGINAL SOURCE FILES INSTEAD AND RUN make */
#ifndef _SPP_ANOMSENSOR_H
#define _SPP_ANOMSENSOR_H
/*********************************************************************
anomsensor.h, distributed as part of Spade v092200.1
Author: James Hoagland, Silicon Defense (hoagland@SiliconDefense.com)
copyright (c) 2000,2001 by Silicon Defense (http://www.silicondefense.com/)
Released under GNU General Public License, see the COPYING file included
with the distribution or http://www.silicondefense.com/spice/ for details.

anomsensor.h contains the types and some macro function declarations that
are used in the tree in Spade

Please send complaints, kudos, and especially improvements and bugfixes to
hoagland@SiliconDefense.com.  As described in GNU General Public License, no
warranty is expressed for this program.
*********************************************************************/

#ifndef ANOMSENSOR_H
#define ANOMSENSOR_H

#include <stdio.h>
#include <limits.h>

/* this needs to be set to a type capable of storing a 32 bit unsigned int */
typedef unsigned int u32;
#define MAX_U32 UINT_MAX
/* this needs to be set to a type capable of storing a 16 bit unsigned int */
typedef unsigned short u16;
#define MAX_U16 USHRT_MAX


typedef enum _features { SIP, DIP, SPORT, DPORT } features;
#define NUM_FEATURES 4
/*typedef enum _features { SIP, DIP, SPORT, DPORT, TTL, WIN } features;
#define NUM_FEATURES 6*/
extern const char *featurename[NUM_FEATURES];

typedef struct _featcomb {
	struct _featcomb *next[NUM_FEATURES];
	double val[NUM_FEATURES];
} *featcomb;

/* index type into memory block data structures */
typedef u32 mindex;

/* mindex used with top bit indicating if one of two datatypes is present */
typedef u32 dmindex;

/* the type of the values of the features */
typedef u32 valtype;

typedef struct _treeroot {
	mindex next;
	dmindex root; /* root node, if top bit is 1, it is a leafnode */
	features type;
} treeroot;

typedef struct _intnode {
	double sum;
	valtype sortpt;
	dmindex left;  /* left and right node, if top bit is 1,
	                  it is a leafnode */
	dmindex right;
	u16 wait; /* the number of additions to the subtree to wait
	             till checking for reblancing */
} intnode;

typedef struct _leafnode {
	double count;
	valtype value;
	mindex nexttree; 
} leafnode;


#define bits2blocksize(b) (1 << b)

#define ROOT_BLOCK_SIZE bits2blocksize(ROOT_BLOCK_BITS)
#define ROOT_BLOCK_MASK ((1 << ROOT_BLOCK_BITS) -1)
#define tree(i) ROOT_M[i>>ROOT_BLOCK_BITS][i&ROOT_BLOCK_MASK]
#define root_index(p,i) ((p<<ROOT_BLOCK_BITS)+i)

#define INT_BLOCK_SIZE bits2blocksize(INT_BLOCK_BITS)
#define INT_BLOCK_MASK ((1 << INT_BLOCK_BITS) -1)
#define intnode(i) INT_M[i>>INT_BLOCK_BITS][i&INT_BLOCK_MASK]
#define intnode_index(p,i) ((p<<INT_BLOCK_BITS)+i)

#define LEAF_BLOCK_SIZE bits2blocksize(LEAF_BLOCK_BITS)
#define LEAF_BLOCK_MASK ((1 << LEAF_BLOCK_BITS) -1)
#define leafnode(i) LEAF_M[i>>LEAF_BLOCK_BITS][i&LEAF_BLOCK_MASK]
#define leafnode_index(p,i) ((p<<LEAF_BLOCK_BITS)+i)

#define rfreenext(n) (n).next
#define ifreenext(n) (n).left
#define lfreenext(n) (n).nexttree

/* something of valtype that cannot be a sortpt */
#define NOT_A_SORTPT MAX_U32

extern mindex TNULL;
extern dmindex DMINDEXMASK;

extern treeroot **ROOT_M;
extern intnode **INT_M;
extern leafnode **LEAF_M;
extern mindex root_freelist;
extern mindex int_freelist;
extern mindex leaf_freelist;

#endif
/*********************************************************************
anomsensor_plug.h, distributed as part of Spade v092200.1
Author: James Hoagland, Silicon Defense (hoagland@SiliconDefense.com)
copyright (c) 2000 by Silicon Defense (http://www.silicondefense.com/)
Released under GNU General Public License, see the COPYING file included
with the distribution or http://www.silicondefense.com/spice/ for details.

anomsensor_plug.h is the header file for anomsensor_plug.c.

Please send complaints, kudos, and especially improvements and bugfixes to
hoagland@SiliconDefense.com.  As described in GNU General Public License, no
warranty is expressed for this program.
*********************************************************************/

#ifndef __SPP_ANOMSENSOR_H__
#define __SPP_ANOMSENSOR_H__

#include "snort.h"
#ifndef WIN32
	#include <netinet/in.h>
#endif
#include <signal.h>
#include <math.h>

#define SPP_ANOMSENSOR_ENABLED 1

#define ALMOST_NEVER ((size_t)3999999999)

/* at what size to discard any value in the tree; each observed instances
   adds one but it is multiplied by SCALE_FACTOR every SCALE_FREQ seconds */
/* these values are coordinated to have a half life of 3 days and to have a
   single instance discarded after a little over a week */
#define MIN_NODE_SIZE 0.18
/* the frequency of scaling */
#define SCALE_FREQ ((size_t)14400)
//#define SCALE_FREQ ALMOST_NEVER
/* the amount by which to scale */
#define SCALE_FACTOR 0.96409


typedef struct _ll_double {
	double val;
	struct _ll_double *next;
} ll_double;

typedef struct _dll_double {
	double val;
	struct _dll_double *prev;
	struct _dll_double *next;
} dll_double;

typedef struct _ll_net {
	u_long netaddr;
	u_long netmask;
	struct _ll_net *next;
} ll_net;

/* list of function prototypes for this preprocessor */
void SetupSpade();
void SpadeInit(u_char *);
void ParseSpadeArgs(char *);
void PreprocSpade(Packet *);
void SpadeHomenetInit(u_char *args);
void SpadeStatInit(u_char *args);
void ParseSpadeStatArgs(char *args);
void SpadeThreshlearnInit(u_char *args);
void ParseSpadeThreshlearnArgs(char *args);
void PreprocSpadeThreshlearn(Packet *p);
void SpadeAdaptInit(u_char *args);
void ParseSpadeAdaptArgs(char *args);
void PreprocSpadeAdapt(Packet *p);
void SpadeAdapt2Init(u_char *args);
void ParseSpadeAdapt2Args(char *args);
void PreprocSpadeAdapt2(Packet *p);
void SpadeAdapt3Init(u_char *args);
void ParseSpadeAdapt3Args(char *args);
void PreprocSpadeAdapt3(Packet *p);
void SpadeSurveyInit(u_char *args);
void ParseSpadeSurveyArgs(char *args);
void PreprocSpadeSurvey(Packet *p);
void SpadeCatchSig(int signal,void *arg);
void CleanUpSpade(int);

/* include other functions from anomsensor_plug.c */
ll_net *create_netlist(char *nets[],int count);
void do_adapt();
void do_adapt3();
double calc_new_thresh();
double thresh_from_obslists();
double anom_ave(double a[],int size);
void reset_obslist(int slot);
dll_double *new_dlink(double val);
void free_dlinks(dll_double *start);
ll_double * new_link(double val);
void free_links(ll_double *start);
double survey_ostat(double loc);
int record_maybe_skip(Packet *p);
double calc_anom(valtype val[]);
void record_packet(Packet *p,valtype val[]);
void set_new_threshold(double t);

#endif  /* ! __SPP_ANOMSENSOR_H__ */


/* $Id: spp_anomsensor.h,v 1.2 2001/01/02 08:06:01 roesch Exp $ */
/*********************************************************************
params.h, distributed as part of Spade v092200.1
Author: James Hoagland, Silicon Defense (hoagland@SiliconDefense.com)
copyright (c) 2000 by Silicon Defense (http://www.silicondefense.com/)
Released under GNU General Public License, see the COPYING file included
with the distribution or http://www.silicondefense.com/spice/ for details.

params.h contains constants that are used for tree memory management in
Spade

Please send complaints, kudos, and especially improvements and bugfixes to
hoagland@SiliconDefense.com.  As described in GNU General Public License, no
warranty is expressed for this program.
*********************************************************************/

#ifndef PARAMS_H
#define PARAMS_H

/* defaults unless recovering from a checkpoint */
#define DEFAULT_ROOT_BLOCK_BITS 10
#define DEFAULT_INT_BLOCK_BITS 9
#define DEFAULT_LEAF_BLOCK_BITS 10

/* these number of blocks are used
   unless file recovering from already uses more blocks */
#define DEFAULT_MAX_ROOT_BLOCKS 4500
#define DEFAULT_MAX_INT_BLOCKS 12000
#define DEFAULT_MAX_LEAF_BLOCKS 9000

#endif

/* $Id: spp_anomsensor.h,v 1.2 2001/01/02 08:06:01 roesch Exp $ */
/*********************************************************************
anommem.h, distributed as part of Spade v092200.1
Author: James Hoagland, Silicon Defense (hoagland@SiliconDefense.com)
copyright (c) 2000 by Silicon Defense (http://www.silicondefense.com/)
Released under GNU General Public License, see the COPYING file included
with the distribution or http://www.silicondefense.com/spice/ for details.

anommem.h is the header file for anommem.c.

Please send complaints, kudos, and especially improvements and bugfixes to
hoagland@SiliconDefense.com.  As described in GNU General Public License, no
warranty is expressed for this program.
*********************************************************************/

#ifndef ANOMMEM_H
#define ANOMMEM_H

void init_mem();
void allocate_mem_blocks();

mindex new_treeinfo(features type);
void free_treeinfo(mindex f);
mindex new_int();
void free_int(mindex f);
mindex new_leaf(valtype val);
void free_leaf(mindex f);

extern unsigned char ROOT_BLOCK_BITS;
extern unsigned char INT_BLOCK_BITS;
extern unsigned char LEAF_BLOCK_BITS;
extern unsigned int MAX_ROOT_BLOCKS;
extern unsigned int MAX_INT_BLOCKS;
extern unsigned int MAX_LEAF_BLOCKS;

#endif

/* $Id: spp_anomsensor.h,v 1.2 2001/01/02 08:06:01 roesch Exp $ */
/*********************************************************************
tree.h, distributed as part of Spade v092200.1
Author: James Hoagland, Silicon Defense (hoagland@SiliconDefense.com)
copyright (c) 2000 by Silicon Defense (http://www.silicondefense.com/)
Released under GNU General Public License, see the COPYING file included
with the distribution or http://www.silicondefense.com/spice/ for details.

tree.h is the header file for tree.c.

Please send complaints, kudos, and especially improvements and bugfixes to
hoagland@SiliconDefense.com.  As described in GNU General Public License, no
warranty is expressed for this program.
*********************************************************************/


extern mindex T[NUM_FEATURES];

#define isleaf(node) (node & DMINDEXMASK)
#define asleaf(leaf) (leaf | DMINDEXMASK)
#define encleaf2mindex(node) (node ^ DMINDEXMASK)
/* arg is a dmindex; if it denotes a leaf, return the count on that leaf
   otherwise return the sum on the interior node */ 
#define count_or_sum(node) (isleaf(node) ? leafnode(encleaf2mindex(node)).count : intnode(node).sum)
#define eleafval(leaf) leafnode(encleaf2mindex(leaf)).value
#define largestval(node) (isleaf(node) ? eleafval(node) : largest_val(node))
#define treetype(t) tree(t).type
#define treeroot(t) tree(t).root
#define treenext(t) tree(t).next
#define intleft(node) intnode(node).left
#define intright(node) intnode(node).right
#define intsum(node) intnode(node).sum
#define intsortpt(node) intnode(node).sortpt
#define intwait(node) intnode(node).wait
#define leafcount(leaf) leafnode(leaf).count
#define leafvalue(leaf) leafnode(leaf).value
#define leafnexttree(leaf) leafnode(leaf).nexttree

/* return the standard wait time for an interior node given the counts on 
   its children */
#define wait_time(c1,c2) (min(max(10,ceil(c1>c2?(2*c2-c1):(2*c1-c2))),MAX_U16))

void tree_init();
void increment_simple_count(features type1,valtype val1);
void increment_2joint_count(features type1,valtype val1,features type2,valtype val2,int skip);
void increment_3joint_count(features type1,valtype val1,features type2,valtype val2,features type3,valtype val3,int skip);
void increment_4joint_count(features type1,valtype val1,features type2,valtype val2,features type3,valtype val3,features type4,valtype val4,int skip);
double prob_simple(features type1,valtype val1);
double prob_cond1(features type,valtype val,features ctype,valtype cval);
double prob_cond2(features type,valtype val,features ctype1,valtype cval1,features ctype2,valtype cval2);
double prob_cond3(features type,valtype val,features ctype1,valtype cval1,features ctype2,valtype cval2,features ctype3,valtype cval3);
double prob_2joint(features type1,valtype val1,features type2,valtype val2);
double prob_Njoint(int size,features type[],valtype val[]);

void scale_and_prune_all_trees(double factor,double threshold);

void write_all_uncond_probs(FILE *f);
void write_all_cond_probs(FILE *f);

float feature_trees_stats(features f,float *amind,float *amaxd,float *aaved,float *awaved);
featcomb calc_all_entropies();
void write_all_entropies(FILE *f,featcomb c);

void print_all_trees();
void printtree(dmindex tree,char *ind);

int sanity_check_trees();

/* generally no need to call these externally */
double tree_value_prob(mindex tree,valtype val);
mindex find_nexttree_of_type(mindex leaf,features type);
mindex get_nexttree_of_type(mindex leaf,features type);
mindex incr_tree_value_count(mindex tree,valtype newval);
mindex increment_value_count(mindex node,valtype val);
mindex add_node_above_to_right(mindex node,valtype val);
mindex add_node_above_to_left(mindex node,valtype val);
mindex add_node_between(mindex node,valtype val);
void rebalance_tree(mindex tree);
void rebalance_subtree(mindex encnode);
int out_of_balance(mindex node);
void free_all_in_tree(mindex tree);
void free_all_in_subtree(dmindex encnode);
void scale_and_prune_tree(mindex tree,double factor,double threshold);
dmindex scale_and_prune_subtree(dmindex encnode,double factor,double threshold,double *change,valtype *newrightmost);
valtype largest_val(mindex node);
mindex dup_intnode(mindex node);
mindex find_leaf(mindex tree,valtype newval);
mindex find_leaf_in_subtree(dmindex encchild,valtype val);
mindex find_leaf2(features type1,valtype val1,features type2,valtype val2);
mindex find_leaf3(features type1,valtype val1,features type2,valtype val2,features type3,valtype val3);
unsigned int feature_tree_stats(mindex tree,features f,unsigned int *smind,unsigned int *smaxd,float *saved,float *swaved,unsigned int *snum_leaves);
unsigned int feature_subtree_stats(mindex encnode,features f,unsigned int *smind,unsigned int *smaxd,float *saved,float *swaved,unsigned int *snum_leaves);
unsigned int tree_stats(mindex tree,unsigned int *mind,unsigned int *maxd,float *aved,float *waved);
double tree_count(mindex tree);
unsigned int num_leaves(mindex tree);
unsigned int num_subtree_leaves(mindex encnode);
unsigned int tree_depth_total(mindex tree);
unsigned int subtree_depth_total(mindex encnode,unsigned int depth);
double weighted_tree_depth_total(mindex tree);
double weighted_subtree_depth_total(mindex encnode,unsigned int depth);
void tree_min_max_depth(mindex tree,unsigned int *mind,unsigned int *maxd);
void subtree_min_max_depth(mindex tree,unsigned int *mind,unsigned int *maxd,unsigned int depth);
void write_feat_val_list(FILE *f,int depth,features feats[],valtype vals[]);
void write_all_tree_uncond_probs(FILE *f,mindex tree,int depth,features feats[],valtype vals[],double treesum);
void write_all_subtree_uncond_probs(FILE *f,dmindex encnode,int depth,features feats[],valtype vals[],double treesum);
void write_all_tree_cond_probs(FILE *f,mindex tree,int depth,features feats[],valtype vals[]);
void write_all_subtree_cond_probs(FILE *f,dmindex encnode,int depth,features feats[],valtype vals[],double treesum);
void write_featurecomb(featcomb C,double val,int depth,features feats[]);
void inc_featurecomb(featcomb C,double val,int depth,features feats[]);
featcomb create_featurecomb(int depth,double val);
void scale_all_featurecomb(featcomb c,double factor);
void add_all_tree_entrsum(featcomb c,mindex tree,int depth,features feats[],double totsum);
void add_all_subtree_entrsum(featcomb c,dmindex encnode,int depth,features feats[],double treesum,double totsum);
void write_all_entropies2(FILE *f,featcomb c,int depth,features feats[]);
void write_feature_names(FILE *f,int depth,features feats[]);
void printtree2(dmindex encnode,char *ind);
void printtree_shallow(dmindex tree);
void printtree2_shallow(dmindex encnode);
int sanity_check_tree(mindex tree);
int sanity_check_subtree(dmindex encnode);

/* $Id: spp_anomsensor.h,v 1.2 2001/01/02 08:06:01 roesch Exp $ */
/*********************************************************************
store.h, distributed as part of Spade v092200.1
Author: James Hoagland, Silicon Defense (hoagland@SiliconDefense.com)
copyright (c) 2000 by Silicon Defense (http://www.silicondefense.com/)
Released under GNU General Public License, see the COPYING file included
with the distribution or http://www.silicondefense.com/spice/ for details.

store.h is the header file for store.c.

Please send complaints, kudos, and especially improvements and bugfixes to
hoagland@SiliconDefense.com.  As described in GNU General Public License, no
warranty is expressed for this program.
*********************************************************************/

/* the current format version # for new statefiles */
#define CUR_FVERS ((unsigned char)1)

int checkpoint(char *filename);
int recover(char *filename);

/* $Id: spp_anomsensor.h,v 1.2 2001/01/02 08:06:01 roesch Exp $ */
#endif /*_SPP_ANOMSENSOR_H*/
