<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 */

function acid_mysql_connect($alert_host, $alert_port, $alert_user, $alert_password, $alert_dbname)
{
  if ($alert_port == "" )
     $db=mysql_connect($alert_host, $alert_user, $alert_password);
  else
     $db=mysql_connect($alert_host.':'.$alert_port, $alert_user, $alert_password);

  if ( !$db )
  {
     echo '<P><B>Error connecting to DB host: </B>'.$alert_host.'<P>Check the DB connection variables 
              in <I>acid_conf.php</I> 
              <PRE>
               = $alert_dbname   : MySQL database name where the alerts are stored 
               = $alert_host     : host where the database is stored
               = $alert_port     : port where the database is stored
               = $alert_user     : username into the database
               = $alert_password : password for the username
              </PRE>';
     die();
  }

  mysql_select_db($alert_dbname, $db);

  if ( mysql_errno($db) > 0 )
  {
     echo '<B>Error connecting to database: '.$alert_dbname.'@'.$alert_host.'</B>. '.mysql_error($db).
          '<P>Check the DB connection variables in <I>acid_conf.php</I> 
              <PRE>
               = $alert_dbname   : MySQL database name where the alerts are stored
               = $alert_host     : host where the database is stored
               = $alert_port     : port where the database is stored
               = $alert_user     : username into the database
               = $alert_password : password for the username
              </PRE>';
     die();
  }

  return $db;
}

function tblExists($db, $table)
{
  $sql = "SELECT * FROM ".$table." LIMIT 0,1";
  $result = mysql_query($sql, $db);
  if ( mysql_errno($db) > 0 )
     return false;
  else
     return true;
}

function fieldExists($db, $table, $field)
{
  $sql = "SELECT ".$field." FROM ".$table." LIMIT 0,1";
  $result = mysql_query($sql, $db);
  if ( mysql_errno($db) > 0 )
     return false;
  else
     return true;
}

function indexExists($db, $table, $field)
{
  $sql = "SHOW INDEX FROM ".$table; 
  $result = mysql_query($sql, $db);
  if ( mysql_errno($db) > 0 )
     return false;
  else
  {
     $num = mysql_num_rows($result);
     $done = false;
     for ($i = 0; $i < $num && !$done; $i++)
     {
         $myrow = mysql_fetch_row($result);

         if ( $myrow[4] == $field )
            $done = true;
     }
    mysql_free_result($result);
  }
 
  return $done;
}

function createDBIndex($db, $table, $field, $index_name)
{
   $sql = 'CREATE INDEX '.$index_name.' ON '.$table.' ('.$field.')';

   mysql_query($sql, $db);
   if ( mysql_errno($db) > 0 )
      ErrorMessage("Unable to CREATE INDEX for '".$field."' : ".mysql_error($db));
   else
      ErrorMessage("Successfully created INDEX for '".$field."'");
}

function verify_db($db, $alert_dbname, $alert_host)
{
  $msg = '<B>The underlying database '.$alert_dbname.'@'.$alert_host.' apears to be invalid</B>';


  $sql = "SELECT ip_src FROM iphdr LIMIT 0,1";
  $result = mysql_query($sql, $db);
  if ( mysql_errno($db) > 0 )
     return $msg.'.  <P>It is an older version.  Only alert databases created by Snort 1.7-beta0 
                  or later are supported'; 
 
  if ( !tblExists($db, "acid_ag") )
     return $msg.'.  <P>Although the database version is fine, the ACID DB structure (acid_ag)
                     is not present. Use the <A HREF="acid_db_setup.php">Setup page</A> to configure
                     and optimize the DB.';

  if ( !tblExists($db, "acid_ag_alert") )
     return $msg.'.  <P>Although the database version is fine, the ACID DB structure (acid_ag_alert)
                     is not present.  Use the <A HREF="acid_db_setup.php">Setup page</A> to configure
                     and optimize the DB.';
  
  return "";
}

/* ******************* DB Query Routines ************************************ */
function EventsByAddr($db, $i, $ip_src0, $ip_src1, $ip_src2, $ip_src3)
{
   $result = mysql_query("SELECT signature FROM event LEFT JOIN iphdr ON ".
                  "event.cid=iphdr.cid AND event.sid=iphdr.sid WHERE ".
                  "(ip_src0='$ip_src0' AND ip_src1='$ip_src1' AND ip_src2='$ip_src2' AND ip_src3='$ip_src3') OR ".
                  "(ip_dst0='$ip_src0' AND ip_dst1='$ip_src1' AND ip_dst2='$ip_src2' AND ip_dst3='$ip_src3')", 
                  $db);
   while ($myrow = mysql_fetch_row($result)) {
   $sig[] = $myrow[0];
   }

   return $sig[$i];
}

function EventCntByAddr($db, $ip_src0, $ip_src1, $ip_src2, $ip_src3)
{
   //$result = mysql_query("SELECT count(signature) FROM event LEFT JOIN iphdr ON ip_src0='$ip_src0' AND ip_src1='$ip_src1' AND ip_src2='$ip_src2' AND ip_src3='$ip_src3';", $db);

   $result = mysql_query("SELECT count(ip_src0) FROM iphdr WHERE ".
                  "(ip_src0='$ip_src0' AND ip_src1='$ip_src1' AND ip_src2='$ip_src2' AND ip_src3='$ip_src3') OR ".
                  "(ip_dst0='$ip_src0' AND ip_dst1='$ip_src1' AND ip_dst2='$ip_src2' AND ip_dst3='$ip_src3')", 
                  $db);

   $myrow = mysql_fetch_row($result);
   $event_cnt = $myrow[0];
   return $event_cnt;
}

function UniqueEventsByAddr($db, $i, $ip_src0, $ip_src1, $ip_src2, $ip_src3)
{
//   $result = mysql_query("SELECT distinctrow signature FROM event LEFT JOIN iphdr ON ip_src0='$ip_src0' AND ip_src1='$ip_src1' AND ip_src2='$ip_src2' AND ip_src3='$ip_src3';", $db);

     $result = mysql_query("SELECT distinctrow signature FROM event LEFT JOIN iphdr ON ".
                  "event.cid=iphdr.cid AND event.sid=iphdr.sid WHERE ".
                  "(ip_src0='$ip_src0' AND ip_src1='$ip_src1' AND ip_src2='$ip_src2' AND ip_src3='$ip_src3') OR ".
                  "(ip_dst0='$ip_src0' AND ip_dst1='$ip_src1' AND ip_dst2='$ip_src2' AND ip_dst3='$ip_src3')", 
                  $db);

   while ($myrow = mysql_fetch_row($result)) {
   $sig[] = $myrow[0];
   }
     return $sig[$i];
}

function UniqueEventCntByAddr($db, $ip_src0, $ip_src1, $ip_src2, $ip_src3)
{
//   $result = mysql_query("SELECT distinctrow signature FROM event LEFT JOIN iphdr ON ip_src0='$ip_src0' AND ip_src1='$ip_src1' AND ip_src2='$ip_src2' AND ip_src3='$ip_src3';", $db);

     $result = mysql_query("SELECT distinctrow signature FROM event LEFT JOIN iphdr ON ".
                  "event.cid=iphdr.cid AND event.sid=iphdr.sid WHERE ".
                  "(ip_src0='$ip_src0' AND ip_src1='$ip_src1' AND ip_src2='$ip_src2' AND ip_src3='$ip_src3') OR ".
                  "(ip_dst0='$ip_src0' AND ip_dst1='$ip_src1' AND ip_dst2='$ip_src2' AND ip_dst3='$ip_src3')", 
                  $db);

   while ($myrow = mysql_fetch_row($result)) {
   $sig[] = $myrow[0];
   }
     return $sig;
}

function UniqueEventTotalsByAddr($db, $ip_src0, $ip_src1, $ip_src2, $ip_src3, $current_event)
{
//   $result = mysql_query("SELECT distinct signature, count(signature) FROM event LEFT JOIN iphdr ON ip_src0='$ip_src0' AND ip_src1='$ip_src1' AND ip_src2='$ip_src2' AND ip_src3='$ip_src3' GROUP BY signature;", $db);

/*   $result = mysql_query("SELECT distinct signature, count(signature) FROM event LEFT JOIN iphdr ON ". 
                  "event.cid=iphdr.cid AND event.sid=iphdr.sid WHERE ".
                  "(ip_src0='$ip_src0' AND ip_src1='$ip_src1' AND ip_src2='$ip_src2' AND ip_src3='$ip_src3') OR ".
                  "(ip_dst0='$ip_src0' AND ip_dst1='$ip_src1' AND ip_dst2='$ip_src2' AND ip_dst3='$ip_src3') ".
                  "GROUP BY signature", $db); 

   while ($myrow = mysql_fetch_row($result)) {
   $unique_event_total[] = $myrow[1];
   }
   
   return $unique_event_total[$i]; */

   $result = mysql_query("SELECT count(signature) FROM event LEFT JOIN iphdr ON ". 
                  "event.cid=iphdr.cid AND event.sid=iphdr.sid WHERE ".
                  "((ip_src0='$ip_src0' AND ip_src1='$ip_src1' AND ip_src2='$ip_src2' AND ip_src3='$ip_src3') OR ".
                  "(ip_dst0='$ip_src0' AND ip_dst1='$ip_src1' AND ip_dst2='$ip_src2' AND ip_dst3='$ip_src3')) ".
                  "AND signature='$current_event'", $db); 

   $myrow = mysql_fetch_row($result);
   $tmp = $myrow[0];
   
   mysql_free_result($result);
   return $tmp;
}

function UniqueSensorCntByAddr($db, $ip_src0, $ip_src1, $ip_src2, $ip_src3, $current_event)
{
   $result = mysql_query("SELECT distinct event.sid FROM event LEFT JOIN iphdr ON ".
                  "event.cid=iphdr.cid AND event.sid=iphdr.sid WHERE ".
                  "((ip_src0='$ip_src0' AND ip_src1='$ip_src1' AND ip_src2='$ip_src2' AND ip_src3='$ip_src3') OR ".
                  "(ip_dst0='$ip_src0' AND ip_dst1='$ip_src1' AND ip_dst2='$ip_src2' AND ip_dst3='$ip_src3')) ".
                  "AND signature='$current_event'", $db);

   while ($myrow = mysql_fetch_row($result)) {
   $sid[] = $myrow[0];
   }

   $count = count($sid);
   return $count;
}

function StartTimeForUniqueEventByAddr($db, $ip_src0, $ip_src1, $ip_src2, $ip_src3, $current_event)
{
   $result = mysql_query("SELECT min(timestamp) FROM event LEFT JOIN iphdr ON ".
                  "event.cid=iphdr.cid AND event.sid=iphdr.sid WHERE ".
                  "((ip_src0='$ip_src0' AND ip_src1='$ip_src1' AND ip_src2='$ip_src2' AND ip_src3='$ip_src3') OR ".
                  "(ip_dst0='$ip_src0' AND ip_dst1='$ip_src1' AND ip_dst2='$ip_src2' AND ip_dst3='$ip_src3')) ".
                  "AND signature = '$current_event';", $db);
   $myrow = mysql_fetch_row($result);
   $start_time = $myrow[0];
   return $start_time;
   mysql_free_result($result);
}

function StopTimeForUniqueEventByAddr($db, $ip_src0, $ip_src1, $ip_src2, $ip_src3, $current_event)
{
   $result = mysql_query("SELECT max(timestamp) FROM event LEFT JOIN iphdr ON ".
                  "event.cid=iphdr.cid AND event.sid=iphdr.sid WHERE ".
                  "((ip_src0='$ip_src0' AND ip_src1='$ip_src1' AND ip_src2='$ip_src2' AND ip_src3='$ip_src3') OR ".
                  "(ip_dst0='$ip_src0' AND ip_dst1='$ip_src1' AND ip_dst2='$ip_src2' AND ip_dst3='$ip_src3')) ".
                  "AND signature = '$current_event';", $db);

   $myrow = mysql_fetch_row($result);
   $stop_time = $myrow[0];
   return $stop_time;
   mysql_free_result($result);
}

?>

