/*
  Copyright (c) 1999 Rafal Wojtczuk <nergal@avet.com.pl>. All rights reserved.
  See the file COPYING for license details.
*/
#ifndef WIN32 /* Not supported. */
#include <libnet.h>
#endif

#include "nids.h"
#include "tcp.h"
#include "util.h"

static int libnetsock = 0;

void
nids_killtcp(struct tcp_stream * a_tcp)
{
#ifndef WIN32 /* Not supported. */
  char buf[IP_H + TCP_H];
  
  libnet_build_ip(TCP_H, 0, 12345, 0, 64, IPPROTO_TCP, a_tcp->addr.saddr,
		  a_tcp->addr.daddr, 0, 0, buf);
  libnet_build_tcp(a_tcp->addr.source, a_tcp->addr.dest,
		   a_tcp->client.seq + a_tcp->server.window / 2, 0,
		   0x4, 32000, 0, 0, 0, buf + IP_H);
  libnet_do_checksum(buf, IPPROTO_TCP, TCP_H);
  libnet_write_ip(libnetsock, buf, TCP_H + IP_H);
  
  libnet_build_ip(TCP_H, 0, 12345, 0, 64, IPPROTO_TCP, a_tcp->addr.daddr,
		  a_tcp->addr.saddr, 0, 0, buf);
  libnet_build_tcp(a_tcp->addr.dest, a_tcp->addr.source,
		   a_tcp->server.seq + a_tcp->client.window / 2, 0,
		   0x4, 32000, 0, 0, 0, buf + IP_H);
  libnet_do_checksum(buf, IPPROTO_TCP, TCP_H);
  libnet_write_ip(libnetsock, buf, TCP_H + IP_H);
#endif
}
int raw_init()
{
#ifndef WIN32 /* Not supported. */
	libnetsock = libnet_open_raw_sock(IPPROTO_RAW);
	if (libnetsock <= 0)
	    return 0;
	else return 1;
#else
	return 1;
#endif
}
