#include <sys/types.h>
#ifdef WIN32
	#include <time.h>
	#include <io.h>
	#include "nids.h"
#else
	#include <sys/time.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>

#ifdef WIN32
	long random();
	void srandom(unsigned int);
#endif
static u_char xor[12];
static u_char perm[12];
static void
getrnd ()
{
  struct timeval s;
  u_int *ptr;
  int fd = open ("/dev/urandom", O_RDONLY);
  if (fd > 0)
    {
      read (fd, xor, 12);
      read (fd, perm, 12);
      close (fd);
      return;
    }

  gettimeofday (&s, 0);
  srandom (s.tv_usec);
  ptr = (u_int *) xor;
  *ptr = random ();
  *(ptr + 1) = random ();
  *(ptr + 2) = random ();
  ptr = (u_int *) perm;
  *ptr = random ();
  *(ptr + 1) = random ();
  *(ptr + 2) = random ();


}
void
init_hash ()
{
  int i, n, j;
  int p[12];
  getrnd ();
  for (i = 0; i < 12; i++)
    p[i] = i;
  for (i = 0; i < 12; i++)
    {
      n = perm[i] % (12 - i);
      perm[i] = p[n];
      for (j = 0; j < 11 - n; j++)
	p[n + j] = p[n + j + 1];
    }
}

u_int
mkhash (u_int src, u_short sport, u_int dest, u_short dport)
{
  u_int res = 0;
  int i;
  u_char data[12];
  *(u_int *) (data) = src;
  *(u_int *) (data + 4) = dest;
  *(u_short *) (data + 8) = sport;
  *(u_short *) (data + 10) = dport;
  for (i = 0; i < 11; i++)
    res = ( (res << 8) + (data[perm[i]] ^ xor[i])) % 0xff100f;
  return res;
}
