/*
  Copyright (c) 1999 Rafal Wojtczuk <nergal@avet.com.pl>. All rights reserved.
  See the file COPYING for license details.
*/

#ifndef _NIDS_NIDS_H
#define _NIDS_NIDS_H
#define NIDS_MAJOR 1
#define NIDS_MINOR 16
#ifdef WIN32
	#include <sys/timeb.h>
	#include <time.h>
	#include <winsock.h>
	typedef unsigned int u_int;
	#define LIBNET_LIL_ENDIAN 1
#else
	#include <sys/types.h>
#endif
#define HAVE_NEW_PCAP 0
enum {
  NIDS_WARN_IP = 1,
  NIDS_WARN_TCP,
  NIDS_WARN_UDP,
  NIDS_WARN_SCAN
};

enum {
  NIDS_WARN_UNDEFINED = 0,
  NIDS_WARN_IP_OVERSIZED,
  NIDS_WARN_IP_INVLIST,
  NIDS_WARN_IP_OVERLAP,
  NIDS_WARN_IP_HDR,
  NIDS_WARN_IP_SRR,
  NIDS_WARN_TCP_TOOMUCH,
  NIDS_WARN_TCP_HDR,
  NIDS_WARN_TCP_BIGQUEUE,
  NIDS_WARN_TCP_BADFLAGS
};

#define NIDS_JUST_EST 1
#define NIDS_DATA 2
#define NIDS_CLOSE 3
#define NIDS_RESET 4
#define NIDS_TIMED_OUT 5

struct tuple4 {
  u_short source;
  u_short dest;
  u_int saddr;
  u_int daddr;
};

struct half_stream {
  char state;
  char collect;
  char collect_urg;

  char *data;
  int offset;
  int count;
  int count_new;
  int bufsize;
  int rmem_alloc;

  int urg_count;
  u_int acked;
  u_int seq;
  u_int ack_seq;
  u_int first_data_seq;
  u_char urgdata;
  u_char count_new_urg;
  u_char urg_seen;
  u_int urg_ptr;
  u_short window;

  struct skbuff *list;
  struct skbuff *listtail;
};

struct tcp_stream {
  struct tuple4 addr;
  char nids_state;
  struct lurker_node *listeners;
  struct half_stream client;
  struct half_stream server;
  struct tcp_stream *next_node;
  struct tcp_stream *prev_node;
  int hash_index;
  struct tcp_stream *next_time;
  struct tcp_stream *prev_time;
  int read;
  struct tcp_stream *next_free;
};

struct nids_prm {
  int n_tcp_streams;
  int n_hosts;
  char *device;
  int sk_buff_size;
  int dev_addon;
  void (*syslog)();
  int syslog_level;
  int scan_num_hosts;
  int scan_delay;
  int scan_num_ports;
  void (*no_mem)(char *);
  int (*ip_filter)();
  char *pcap_filter;
  int promisc;
  int one_loop_less;
};

int nids_init();
void nids_register_ip_frag(void (*));
void nids_register_ip(void (*));
void nids_register_tcp(void (*));
void nids_register_udp(void (*));
void nids_killtcp(struct tcp_stream *);
void nids_discard(struct tcp_stream *, int);
void nids_run();
int nids_getfd();
int nids_next();
#ifdef WIN32
int gettimeofday(struct timeval *tv,struct timezone *tz);
void *GetAdapterFromList(void* device,int index);

#define LOG_ALERT       1       /* action must be taken immediately */
#define LOG_LOCAL0      (16<<3) /* reserved for local use */
#define HAVE_BSD_UDPHDR 1
#define LITTLE_ENDIAN 1234
#define BYTE_ORDER LITTLE_ENDIAN
#endif

extern struct nids_prm nids_params;
extern char *nids_warnings[];
extern char nids_errbuf[];

#endif /* _NIDS_NIDS_H */
