#include <stdio.h>
#include <string.h>
#include <windows.h>
#include <sys/timeb.h>
#include <time.h>

/****************************************************************************
 *
 * Function: gettimeofday(struct timeval *, struct timezone *)
 *
 * Purpose:  Get current time of day.
 *
 * Arguments: tv => Place to store the curent time of day.
 *            tz => Ignored.
 *
 * Returns: 0 => Success.
 *
 ****************************************************************************/

int gettimeofday(struct timeval *tv, struct timezone *tz) {
  struct _timeb tb;

	if(tv == NULL)
		return -1;

	_ftime(&tb);
	tv->tv_sec = tb.time;
	tv->tv_usec = ((int) tb.millitm) * 1000;
	return 0;
}

int setenv(const char *name, const char *value, int overwrite)
{
	char buf[1024];
	memset(buf, 0, sizeof(buf));
	_snprintf(buf, sizeof(buf) - 1, "%s=%s", name, value);
	return _putenv(buf);
}

/****************************************************************************
 *
 * Function: init_winsock(void)
 *
 * Purpose:  Initialize winsock.
 *
 * Arguments: None.
 *
 * Returns: 0 => Initilization failed.
 *          1 => Initilization succeeded.
 *
 ****************************************************************************/

int init_winsock(void) {
  WORD wVersionRequested = MAKEWORD(1, 1);
  WSADATA wsaData;

  if (WSAStartup(wVersionRequested, &wsaData)) {
    return 0;
  }

  if (LOBYTE(wsaData.wVersion) < 1 || HIBYTE(wsaData.wVersion) < 1) {
    WSACleanup();
    return 0;
  }
	
  return 1;
}	
